IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[EST_NF_ENT_IT_HIST_CUSTO]') 
					AND type in (N'U')) 
BEGIN
 
	SET ANSI_NULLS ON
	SET QUOTED_IDENTIFIER ON
	SET ANSI_PADDING ON
	CREATE TABLE [dbo].[EST_NF_ENT_IT_HIST_CUSTO](

		[CD_CTR] [int] NOT NULL  IDENTITY (1,1)  ,
		[CD_EMP] [int] NOT NULL   ,
	 	[CD_FILIAL] [int] NOT NULL  ,
		[CD_NF] [int] NOT NULL  ,
		[CD_PROD] [int] NOT NULL  ,  
		[VLR_CUSTO_NOVO] [money] NOT NULL, 
		[VLR_CUSTO_ANT] [money] NOT NULL ,
		[DT_CAD] [datetime] NOT NULL ,

	 CONSTRAINT [PK_EST_NF_ENT_IT_HIST_CUSTO] PRIMARY KEY CLUSTERED 
	(	CD_CTR  )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, 
	ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
	) ON [PRIMARY]

	SET ANSI_PADDING OFF 

	ALTER TABLE [dbo].[EST_NF_ENT_IT_HIST_CUSTO]  WITH CHECK 
		ADD  CONSTRAINT [FK_EST_NF_ENT_IT_HIST_CUSTO_EST_NF_ENT_IT] FOREIGN KEY([CD_EMP],[CD_FILIAL],[CD_NF],[CD_PROD])
	REFERENCES [dbo].[EST_NF_ENT_IT] ([CD_EMP],[CD_FILIAL],[CD_NF],[CD_PROD]) ON DELETE CASCADE

	ALTER TABLE [dbo].[EST_NF_ENT_IT_HIST_CUSTO] CHECK CONSTRAINT [FK_EST_NF_ENT_IT_HIST_CUSTO_EST_NF_ENT_IT] 
	 
	ALTER TABLE [dbo].[EST_NF_ENT_IT_HIST_CUSTO] ADD CONSTRAINT
		[DF_EST_NF_ENT_IT_HIST_CUSTO_CD_EMP] DEFAULT 0 FOR CD_EMP
		
	ALTER TABLE [dbo].[EST_NF_ENT_IT_HIST_CUSTO] ADD CONSTRAINT
		[DF_EST_NF_ENT_IT_HIST_CUSTO_CD_FILIAL] DEFAULT 0 FOR CD_FILIAL

	ALTER TABLE [dbo].[EST_NF_ENT_IT_HIST_CUSTO] ADD CONSTRAINT
		[DF_EST_NF_ENT_IT_HIST_CUSTO_CD_NF] DEFAULT 0 FOR CD_NF


	ALTER TABLE [dbo].[EST_NF_ENT_IT_HIST_CUSTO] ADD CONSTRAINT
		[DF_EST_NF_ENT_IT_HIST_CUSTO_CD_PROD] DEFAULT 0 FOR CD_PROD

		
	ALTER TABLE [dbo].[EST_NF_ENT_IT_HIST_CUSTO] ADD CONSTRAINT
		[DF_EST_NF_ENT_IT_HIST_CUSTO_VLR_CUSTO_NOVO] DEFAULT 0 FOR VLR_CUSTO_NOVO
		
	ALTER TABLE [dbo].[EST_NF_ENT_IT_HIST_CUSTO] ADD CONSTRAINT
		[DF_EST_NF_ENT_IT_HIST_CUSTO_VLR_CUSTO_ANT] DEFAULT 0 FOR VLR_CUSTO_ANT

 END
